%
% Compare different similarity measures and generate Tables 4-1 and 4-2 in the book
%
% Dongrui WU (dongruiw@usc.edu); 4/19/2009

clear all;
close all;
clc;

%% get the FOUs from the IA
[words,MFs]=getFOUs();
N=length(words);

%% Mitchell's method
SMsM=zeros(N,N);
for i=1:N
    for j=1:N
        SMsM(i,j)=Mitchell(MFs(i,:),MFs(j,:));
    end
end
tableM=latexTable41(SMsM,words)

%% Gorza's method
SMsG=zeros(N,N);
for i=1:N
    for j=1:N
        SMsG(i,j)=Gorza(MFs(i,:),MFs(j,:));
    end
end
tableG=latexTable41(SMsG,words)

%% Bustince's method
SMsB=zeros(N,N);
for i=1:N
    for j=1:N
        SMsB(i,j)=Bustince(MFs(i,:),MFs(j,:));
    end
end
tableB=latexTable41(SMsB,words)

%% Zeng and Li's method
SMsZ=zeros(N,N);
for i=1:N
    for j=1:N
        SMsZ(i,j)=ZengLi(MFs(i,:),MFs(j,:));
    end
end
tableZ=latexTable41(SMsZ,words)

%% VSM
SMsV=zeros(N,N);
tic
for i=1:N
    for j=1:N
        SMsV(i,j)=VSM(MFs(i,:),MFs(j,:));
    end
end
timeV=toc
tableV=latexTable41(SMsV,words)

%% Jaccard's method
SMsJ=zeros(N,N);
tic
for i=1:N
    for j=1:N
        SMsJ(i,j)=Jaccard(MFs(i,:),MFs(j,:));
    end
end
timeJ=toc
tableJ=latexTable41(SMsJ,words)

%%
table=latexTable42(SMsJ,words)
